/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.EmitterProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public abstract class PropParticle
extends TextureSheetParticle {
    PropertyParticleOptions options;

    protected PropParticle(PropertyParticleOptions options, ClientLevel level, double x, double y, double z) {
        this(options, level, x, y, z, 0.0, 0.0, 0.0);
    }

    protected PropParticle(PropertyParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.options = options;
        if (this.tinted()) {
            this.setColorFromProps();
        }
    }

    public void tick() {
        super.tick();
        this.setColorFromProps();
    }

    public void setColorFromProps() {
        ParticleColor particleColor = this.getPropColor();
        if (particleColor == null) {
            return;
        }
        this.setColorFromParticleColor(particleColor);
    }

    @Nullable
    public ParticleColor getPropColor() {
        ParticleTypeProperty property = (ParticleTypeProperty)this.options.map.get((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get());
        if (property != null && property.getColor().isTintDisabled()) {
            return this.getDefaultColor();
        }
        return property != null ? property.getColor().particleColor : this.getDefaultColor();
    }

    public void setColorFromParticleColor(ParticleColor color) {
        if (color == null) {
            return;
        }
        EmitterProperty emitterProp = (EmitterProperty)this.options.map.get((IPropertyType)ParticlePropertyRegistry.EMITTER_PROPERTY.get());
        color = emitterProp != null ? color.transition(emitterProp.age + this.age * 50) : color.transition((int)(this.level.getGameTime() % 20L + (long)(this.age * 50)));
        float colorR = color.getRed();
        float colorG = color.getGreen();
        float colorB = color.getBlue();
        this.setColor(colorR, colorG, colorB);
    }

    @Nullable
    public ParticleColor getDefaultColor() {
        return null;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public boolean tinted() {
        return false;
    }

    @FunctionalInterface
    public static interface ParticleProvider<T extends PropertyParticleOptions> {
        @Nullable
        public TextureSheetParticle createParticle(T var1, ClientLevel var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }

    public static class Provider
    implements net.minecraft.client.particle.ParticleProvider<PropertyParticleOptions> {
        private final SpriteSet sprite;
        ParticleProvider<PropertyParticleOptions> particleConstructor;

        public Provider(ParticleProvider<PropertyParticleOptions> particleConstructor, SpriteSet pSprites) {
            this.sprite = pSprites;
            this.particleConstructor = particleConstructor;
        }

        public Provider(SpriteSet pSprites, ParticleProvider<PropertyParticleOptions> particleConstructor) {
            this.sprite = pSprites;
            this.particleConstructor = particleConstructor;
        }

        public TextureSheetParticle createParticle(PropertyParticleOptions pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            TextureSheetParticle particle = this.particleConstructor.createParticle(pType, pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            if (this.sprite != null) {
                particle.pickSprite(this.sprite);
            }
            return particle;
        }
    }
}

